<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2016 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/
	require('config.php');
	require('lib/db-session-handler.php');
	require('includes/init.php');
	require('includes/db-core.php');
	require('includes/helper-functions.php');
	require('lib/phpmailer/phpmailer_required.php');
	require('lib/password-hash.php');
	
	$_POST = json_decode(file_get_contents('php://input'), true);
	$target_email = strtolower(trim($_POST['target_email'] ?? ''));

	if(empty($target_email)){
		die("Invalid parameters.");
	}
	
	
	$dbh = mf_connect_db();
	$ssl_suffix = mf_get_ssl_suffix();
	$mf_settings = mf_get_settings($dbh);
	
	//validate the email address
	$is_registered_email = false;
	
	$query  = "SELECT user_id,user_fullname FROM `".MF_TABLE_PREFIX."users` WHERE `user_email`=? and `status`=1";
	$params = array($target_email);
	
	$sth = mf_do_query($query,$params,$dbh);
	$row = mf_do_fetch_result($sth);
	
	if(!empty($row['user_id'])){
		$user_id = $row['user_id'];

		$user_fullname_array = explode(' ',$row['user_fullname']);
		$user_firstname 	 = $user_fullname_array[0];
	}else{
		echo '{"status" : "error", "message" : "Incorrect email address. Please try again."}';
		return true;
	}

	//generate reset hash
	$reset_hash = md5(uniqid(rand(), true)); 

	//save it into ap_users table
	$query 	= "UPDATE ".MF_TABLE_PREFIX."users SET reset_hash=?,reset_date=now() WHERE user_id=?"; 
	$params = array($reset_hash,$user_id);
					
	mf_do_query($query,$params,$dbh);

	$http_host = parse_url($mf_settings['base_url'], PHP_URL_HOST);
	
	//send reset link to user
	$q_string  = base64_encode("user_id={$user_id}&reset_hash={$reset_hash}");
	$reset_url = 'http'.$ssl_suffix.'://'.$http_host.mf_get_dirname($_SERVER['PHP_SELF']).'/reset.php?q='.$q_string;

	$reset_result = mf_send_password_reset($dbh,$target_email,$user_firstname,$reset_url);
	if($reset_result === true){
		echo '{"status" : "ok", "message" : "A reset password link has been generated and sent to your email. Please check your email and follow the instruction."}';
	}else{
		echo '{"status" : "error", "message" : "Unable to send password reset link. '.$reset_result.'"}';
	}

?>